#include <bits/stdc++.h>
using namespace std;

#define N_MAX 600000
#define COOL_HASH(a, b) (static_cast<int64_t>(a) << 32 | static_cast<int64_t>(b))

int N, M, Q, P;
int A[N_MAX];
int ans[N_MAX];
unordered_map<int64_t, int> hashed_answers;

struct str_upit {
    int a, b;
};
str_upit upiti[N_MAX];
vector<unordered_map<int, bool>> graph;
unordered_map<int, bool> memo;

bool dfs(map<int, bool>& nodes, unordered_map<int, bool> visited, int current, int u, int v) {
    // base case
    if(current == v) {
        nodes[current] = true;
        return true;
    }

    // no need to look in a node that for sure contains the path
    if(memo.find(current) != memo.end()) {
        //cout << "hi :3333" << endl;
        return memo[current];
    }

    // make sure we didn't visit it before, if we did wouldn't count as path
    if(visited.find(current) != visited.end() && visited[current] == true) {
        return false;
    }

    // current node is visited
    visited[current] = true;

    //cout << "current: " << current << endl;

    bool is_in_path = false;    // is our node connected with a node that is visited?
    unordered_map<int, bool>& neighbors = graph[current];
    auto it = neighbors.begin();
    while(it != neighbors.end()) {
        //cout << "vertex " << current << ", neighbor " << it->first << endl;

        // search further
        if(dfs(nodes, visited, it->first, u, v)) {
            // yippee, put our in nodes that are on a path and our result
            nodes[current] = true;
            is_in_path = true;
        }
        it++;
    }
    //cout << "result: " << current << " " << is_in_path << endl;

    if(is_in_path)
        memo[current] = is_in_path;

    return is_in_path;
}

int resi_upit(int i) {
    // get a and b
    int a = upiti[i].a;
    int b = upiti[i].b;
    int prev_ans = 0;
    if(i != 0)
        prev_ans = ans[i - 1];
    a = (a + prev_ans * P - 1) % N + 1;
    b = (b + prev_ans * P - 1) % N + 1;
    //cout << "A: " << a << ", B: " << b << endl;

    int answer;
    if(hashed_answers.find(COOL_HASH(a, b)) != hashed_answers.end()) {
        answer = hashed_answers[COOL_HASH(a, b)];
    } else {
        // dfs, simple paths
        map<int, bool> nodes;
        memo.clear();
        dfs(nodes, {}, a, a, b);

        // print out, testing and debugging ofc
        /*auto it = nodes.begin();
        while(it != nodes.end()) {
            cout << it->first << " ";
            it++;
        }
        cout << endl;*/

        // get median value
        auto it = nodes.begin();
        advance(it, static_cast<int>(ceil(static_cast<float>(nodes.size()) / 2)) - 1);
        //cout << "whaaa : " << static_cast<int>(ceil(static_cast<float>(nodes.size()) / 2)) << endl;
        answer = A[it->first - 1];
        hashed_answers[COOL_HASH(a, b)] = answer;
    }

    // save answer, we need it for later
    ans[i] = answer;
    return answer;
}

int main() {
    // fast input
    ios_base::sync_with_stdio(false);
    //cin.tie(0);

    // input values and array with values
    cin >> N >> M >> Q >> P;
    for(int i = 0; i < N; i++) {
        cin >> A[i];
    }

    // input graph
    graph.resize(N + 1000);
    for(int i = 0; i < M; i++) {
        int u, v;
        cin >> u >> v;
        graph[u][v] = true;
        graph[v][u] = true;
    }

    // input upiti
    for(int i = 0; i < Q; i++) {
        cin >> upiti[i].a >> upiti[i].b;
    }

    // resi svaki upit i print
    for(int i = 0; i < Q; i++) {
        cout << resi_upit(i) << endl;
    }


    return 0;
}